package ru.yandex.chemodan.util.yt;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;

/**
 * @author yashunsky
 */
public class YtTableNameResolver {
    private final YtHelper ytRunner;

    public YtTableNameResolver(Yt ytRunner, RetryPolicy retryPolicy) {
        this.ytRunner = new YtHelper(ytRunner, retryPolicy);
    }

    public Option<YPath> getLatestNotEmptyTable(YPath path, LocalDate by) {
        return ytRunner.getExistingDatesAndLatestNotEmptyDate(path, by)._2.map(date -> path.child(String.valueOf(date)));
    }
}
