package ru.yandex.chemodan.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
public class ClientInfoAndUidFromTvmInterceptor implements ActionDispatcherInterceptor {

    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) throws Exception {
        HttpServletRequestX request = webRequest.getHttpServletRequest();

        Option<String> clientIdO = getClientId(request);
        Option<String> uidO = getUid(request);

        clientIdO.ifPresent(clientId -> request.setAttribute(DiskLog4jRequestLog.CLIENT_ID_ATTRIBUTE, clientId));
        uidO.ifPresent(uid -> request.setAttribute(DiskLog4jRequestLog.UID_ATTRIBUTE, uid));
    }

    private Option<String> getClientId(HttpServletRequestX request) {
        return Option.ofNullable(request.getAttribute(Tvm2Filter.TVM_CLIENT_ID_ATTR))
                .map(Object::toString);
    }

    private Option<String> getUid(HttpServletRequestX request) {
        return Option.ofNullable(request.getAttribute(Tvm2Filter.TVM_UID_ATTR))
                .map(Object::toString);
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.SECURITY_INTERCEPTOR_ORDER;
    }
}
