package ru.yandex.chemodan.web;

import java.util.List;
import java.util.TimeZone;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.json.jackson.IntEnumModule;
import ru.yandex.commune.json.jackson.JodaTimeModule;
import ru.yandex.commune.json.jackson.ReadableInstantModule;
import ru.yandex.commune.json.jackson.StringEnumModule;
import ru.yandex.commune.json.jackson.bolts.BoltsModule;

@Configuration
public class JacksonContextConfiguration {

    @Bean
    public ObjectMapper objectMapper(List<Module> modules) {
        final ObjectMapper om = new ObjectMapper()
                .configure(SerializationFeature.INDENT_OUTPUT, true)
                .configure(MapperFeature.AUTO_DETECT_GETTERS, false)
                .configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false)
                .configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)
                .setSerializationInclusion(JsonInclude.Include.NON_NULL)
                .disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)
                .disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)
                .enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)
                .enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);

        for (Module module : modules) {
            om.registerModule(module);
        }
        om.setTimeZone(TimeZone.getDefault());
        return om;
    }

    @Bean
    public ReadableInstantModule readableInstantModule() {
        return new ReadableInstantModule();
    }

    @Bean
    public BoltsModule boltsModule() {
        return new BoltsModule();
    }

    @Bean
    public JodaTimeModule jodaTimeModule() {
        return new JodaTimeModule();
    }

    @Bean
    public StringEnumModule stringEnumModule() {
        return new StringEnumModule();
    }

    @Bean
    public IntEnumModule intEnumModule() {
        return new IntEnumModule();
    }
}
