package ru.yandex.chemodan.web;

import java.io.OutputStream;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;

public class JacksonMapResultSerializer extends AbstractResultSerializer<Map<?, ?>> {
    private final ObjectMapper objectMapper;

    public JacksonMapResultSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    protected void serializeSafely(Map<?, ?> result, ActionInvocationContext context, OutputStream out) throws Exception {
        objectMapper.writeValue(out, result);
    }

    @Override
    protected boolean supports(Object result) {
        return result instanceof Map<?, ?>;
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
