package ru.yandex.chemodan.web;

import java.io.OutputStream;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;

public class JacksonPojoResultSerializer extends AbstractResultSerializer<JacksonPojo> {
    private final ObjectMapper objectMapper;

    public JacksonPojoResultSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    protected void serializeSafely(JacksonPojo result, ActionInvocationContext context, OutputStream out) throws Exception {
        objectMapper.writeValue(out, result);
    }

    @Override
    protected boolean supports(Object result) {
        return result instanceof JacksonPojo;
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
