package ru.yandex.chemodan.xiva;

import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class DiskLikeXivaPushBody implements XivaPushBody {
    protected static final BenderMapper mapper = new BenderMapper(
            new BenderConfiguration(
                    BenderConfiguration.defaultSettings(),
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(DiskLikeXivaPushBody.class, new JsonValueMarshaller() {
                                private final BenderMapper basicMapper = new BenderMapper();

                                @Override
                                public void writeJsonToField(BenderJsonWriter wr, Object obj, MarshallerContext ctx) {
                                    basicMapper.serializeJson(obj, wr, ctx);
                                }
                            })
                            .build()
            )
    );

    @BenderPart(name="tag")
    final String eventType;

    public DiskLikeXivaPushBody(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public void writePushBodyAsJson(BenderJsonWriter writer, MarshallerContext context) {
        mapper.serializeJson(new Wrapper(this), writer, context);
    }

    @Bendable
    protected static class Wrapper {
        @BenderPart(name = "root")
        final DiskLikeXivaPushBody content;

        public Wrapper(DiskLikeXivaPushBody content) {
            this.content = content;
        }
    }
}
