package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DiskLikeXivaPushBodyTest {
    @Test
    public void testJsonBasic() {
        String eventType = "event-type";

        Assert.equals(
                "{\"root\":{\"tag\":\"" + eventType + "\"}}",
                XivaTestUtils.getSerializedForm(new DiskLikeXivaPushBody(eventType))
        );
    }

    @Test
    public void testJsonInheritance() {
        String eventType = "event-type";

        Assert.equals("{\"root\":" +
                "{"
                    + "\"tag\":\"" + eventType + "\","
                    + "\"values\":{"
                        + "\"str_param\":\"str_value\","
                        + "\"number_param\":123"
                    + "}"
                + "}"
                + "}",
                XivaTestUtils.getSerializedForm(new AncestorOfXivaPushBody("event-type"))
        );
    }

    @Bendable
    private static class AncestorOfXivaPushBody extends DiskLikeXivaPushBody {
        @BenderPart(name = "values")
        final Values values = new Values();

        AncestorOfXivaPushBody(String tag) {
            super(tag);
        }

        @Bendable
        static class Values {
            @BenderPart(name = "str_param", strictName = true)
            final String string = "str_value";

            @BenderPart(name = "number_param", strictName = true)
            final int number = 123;
        }
    }
}
