package ru.yandex.chemodan.xiva;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaClient {
    private final BasicXivaClient basicClient;

    private final MapF<String, String> tokens;

    public XivaClient(BasicXivaClient basicClient, MapF<String, String> tokens) {
        this.basicClient = basicClient;
        this.tokens = tokens;
    }

    public XivaSingleTokenClient toSingleTokenClient(String serviceName) {
        return toSingleTokenClient(serviceName, Option.empty());
    }

    public XivaSingleTokenClient toSingleTokenClient(String serviceName, String broadcastServiceName) {
        return toSingleTokenClient(serviceName, Option.of(broadcastServiceName));
    }

    private XivaSingleTokenClient toSingleTokenClient(String serviceName, Option<String> broadcastServiceName) {
        return new XivaSingleTokenClient(basicClient,
                tokens.getTs(serviceName),
                broadcastServiceName.map(tokens::getTs)
        );
    }
}
