package ru.yandex.chemodan.xiva;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.spring.MapProperties;

/**
 * @author tolmalev
 */
@Configuration
public class XivaClientContextConfiguration {
    @Value("${xiva.host}")
    private String xivaHost;

    @Bean
    @Primary
    public BasicXivaClient basicXivaClient() {
        return new BasicXivaClient(xivaHost, xivaHttpClientConfigurator().configure());
    }

    @Bean
    protected MapProperties xivaTokensMapProperties() {
        return new MapProperties("xiva.service_tokens");
    }

    @Bean
    @Primary
    public XivaClient mainXivaPushClient() {
        return new XivaClient(basicXivaClient(), xivaTokensMapProperties().get());
    }

    @Bean
    @OverridableValuePrefix("xiva")
    public HttpClientConfigurator xivaHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
