package ru.yandex.chemodan.xiva;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class XivaEventRecipient extends DefaultObject {
    private static final XivaEventRecipient BROADCAST = new XivaEventRecipient() {

    };

    public Option<String> getUrlValueO() {
        return Option.empty();
    }

    private XivaEventRecipient() {

    }

    public static XivaEventRecipient broadcast() {
        return BROADCAST;
    }

    public static User passport(long uid) {
        return passport(new PassportUid(uid));
    }

    public static User arbitrary(String value) {
        return new Arbitrary(value);
    }

    public static User passport(PassportUid uid) {
        return new Passport(uid);
    }

    public static Single passportSubscription(PassportUid uid, String subscriptionId) {
        return subscription(passport(uid), subscriptionId);
    }

    public static Single subscription(User user, String subscriptionId) {
        return new Subscription(user, subscriptionId);
    }

    public static XivaEventRecipient multipleSubscriptions(MapF<PassportUid, XivaSubscription> subscriptionMap) {
        ListF<Single> subscriptionList = subscriptionMap.mapEntries((uid, subscription) -> passportSubscription(uid, subscription.getId()));
        return new Multiple(subscriptionList);
    }

    public static XivaEventRecipient multiple(Single first, Single... recipients) {
        return new Multiple(Cf.list(first).plus(recipients));
    }

    public boolean isBroadcast() {
        return this == BROADCAST;
    }

    public boolean isBulk() {
        return this instanceof Multiple || this instanceof Subscription;
    }

    public ListF<Single> getRecipients() {
        return Cf.list();
    }

    private static class Multiple extends XivaEventRecipient {
        final ListF<Single> recipients;

        private Multiple(ListF<Single> recipients) {
            this.recipients = recipients;
        }

        @Override
        public ListF<Single> getRecipients() {
            return recipients;
        }

        @Override
        public String toString() {
            return String.format("[%s]", recipients.mkString(","));
        }
    }

    public static abstract class Single extends XivaEventRecipient {
        public abstract void writeJsonTo(BenderJsonWriter json);
    }

    private static class Subscription extends Single {
        final User user;

        final String subscriptionId;

        Subscription(User user, String subscriptionId) {
            this.user = user;
            this.subscriptionId = subscriptionId;
        }

        @Override
        public ListF<Single> getRecipients() {
            return Cf.list(this);
        }

        @Override
        public void writeJsonTo(BenderJsonWriter json) {
            json.writeObjectStart();
            json.writeFieldName(user.stringValue());
            json.writeString(subscriptionId);
            json.writeObjectEnd();
        }

        @Override
        public String toString() {
            return String.format("%s:%s", user, subscriptionId);
        }
    }

    public static abstract class User extends Single {
        protected abstract String stringValue();

        @Override
        public Option<String> getUrlValueO() {
            return Option.of(stringValue());
        }

        @Override
        public void writeJsonTo(BenderJsonWriter json) {
            json.writeString(stringValue());
        }

        @Override
        public String toString() {
            return stringValue();
        }
    }

    private static class Passport extends User {
        final PassportUid uid;

        Passport(PassportUid uid) {
            this.uid = uid;
        }

        @Override
        protected String stringValue() {
            return uid.toString();
        }
    }

    private static class Arbitrary extends User {
        final String value;

        private Arbitrary(String value) {
            this.value = value;
        }

        @Override
        protected String stringValue() {
            return value;
        }
    }
}
