package ru.yandex.chemodan.xiva;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPayloadJsonWriterHelper {

    private final BenderJsonWriter proxy = (BenderJsonWriter) Proxy.newProxyInstance(
            BenderJsonWriter.class.getClassLoader(),
            new Class<?>[]{BenderJsonWriter.class},
            (p, method, args) -> invoke(method, args)
    );

    private final BenderJsonWriter json;

    private final Runnable callback;

    private int level = 0;

    private final ListF<String> topLevelFields = Cf.arrayList();

    public XivaPayloadJsonWriterHelper(BenderJsonWriter json, Runnable callback) {
        this.json = json;
        this.callback = callback;
    }

    public BenderJsonWriter getJsonWriterProxy() {
        return proxy;
    }

    private Object invoke(Method method, Object[] args) throws ReflectiveOperationException {
        switch (method.getName()) {
            case "writeObjectStart":
                level++;
                break;

            case "writeFieldName":
                if (level == 1) {
                    topLevelFields.add(args[0].toString());
                }
                break;

            case "writeObjectEnd":
                level--;
                if (level == 0) {
                    callback.run();
                }
        }
        return method.invoke(json, args);
    }

    public ListF<String> getTopLevelFields() {
        return topLevelFields.unmodifiable();
    }
}
