package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPushBodyRepackTest {
    @Test
    public void includeSpecialAndAllPayloadFieldsToAllServices() {
        Assert.equals(
                Cf.<XivaPushBodyRepack.ServiceRepack>arrayList()
                        .plus1(consRepackWithIncludedSpecialAndAllPayloadFields(XivaPushService.OTHER))
                        .plus1(consRepackWithIncludedSpecialAndAllPayloadFields(XivaPushService.APNS))
                        .toMapMappingToKey(XivaPushBodyRepack.ServiceRepack::getService),
                new XivaPushBodyRepack()
                        .includeSpecialAndAllPayloadFieldsToAllServices()
                        .getFixedServiceRepacks()
        );
    }

    private static XivaPushBodyRepack.ServiceRepack
    consRepackWithIncludedSpecialAndAllPayloadFields(XivaPushService service)
    {
        return new XivaPushBodyRepack.ServiceRepack(service)
                .includeAllPayloadFields()
                .includePushToken("r")
                .includeTransitId("transit_id");
    }
}
