package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author akirakozov
 */
public class XivaPushBodyTest {
    @Test
    public void serializeBodyWithSimplePayload() {
        serializeAndAssertEquals("bodyWithSimplePayload.json", new TestPushBody(), "tag1", "tag2");
    }

    @Test
    public void serializeBodyWithBatchRecipients() {
        XivaEventRecipient recipients = XivaEventRecipient.multiple(
                XivaEventRecipient.passport(123),
                XivaEventRecipient.subscription(XivaEventRecipient.passport(456), "mob:987654321")
        );
        serializeAndAssertEquals("bodyWithBatchRecipients.json", recipients, new TestPushBody(), "tag1", "tag2");
    }

    static void serializeAndAssertEquals(String filename, XivaPushBody pushBody, String... tags) {
        serializeAndAssertEquals(filename, XivaEventRecipient.passport(1L), pushBody, tags);
    }

    private static void serializeAndAssertEquals(String filename,
            XivaEventRecipient recipient, XivaPushBody pushBody, String... tags)
    {
        JsonAssert.equals(XivaPushBodyTest.class, filename, serialize(recipient, pushBody, tags));
    }

    static String serialize(XivaEventRecipient recipient, XivaPushBody pushBody, String... tags) {
        return new String(
                new XivaEvent(recipient, "test", Cf.list(tags))
                        .withBody(pushBody)
                        .serializeBody()
        );
    }

    static class TestPushBody implements XivaPushBody {
        @Override
        public void writePushBodyAsJson(BenderJsonWriter writer, MarshallerContext context) {
            writer.writeObjectStart();
            writer.writeFieldName("test-field");
            writer.writeString("value");
            writer.writeObjectEnd();
        }
    }
}
