package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPushBodyWithRepackTest {
    @Test
    public void serializeBodyWithRepackAndServiceSpecificParams() {
        serializeAndAssertEquals("bodyWithRepackAndServiceSpecificParams.json",
                new TestPushBodyWithRepackAndSpecificParams(), "tag2", "tag3");
    }

    private static void serializeAndAssertEquals(String filename, XivaPushBody pushBody, String... tags) {
        XivaPushBodyTest.serializeAndAssertEquals(filename, pushBody, tags);
    }

    private static class TestPushBodyWithRepackAndSpecificParams extends XivaPushBodyTest.TestPushBody
            implements XivaPushBody
    {
        @Override
        public XivaPushBodyRepack getRepack() {
            return new XivaPushBodyRepack()
                    .addCustomFields(getServiceSpecificParams())
                    .includeSpecialAndAllPayloadFieldsToAllServices();
        }

        private MapF<XivaPushService, MapF<String, Object>> getServiceSpecificParams() {
            return Cf.map(
                    XivaPushService.APNS, Cf.map("comp_vers", 101),
                    XivaPushService.GCM, Cf.map("comp_vers", 202));
        }
    }
}
