package ru.yandex.chemodan.xiva;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPushMapBody implements XivaPushBody {
    private final boolean asString;

    private final MapF<String, Object> body;

    private XivaPushMapBody(boolean asString, MapF<String, Object> body) {
        this.asString = asString;
        this.body = body;
    }

    public static XivaPushMapBody consStr(MapF<String, Object> body) {
        return new XivaPushMapBody(true, body);
    }

    public static XivaPushMapBody consJson(MapF<String, Object> body) {
        return new XivaPushMapBody(false, body);
    }

    @Override
    public void writePushBodyAsJson(BenderJsonWriter writer, MarshallerContext context) {
        if (asString) {
            writer.writeString(XivaSerializeUtil.serializeToString(body));
        } else {
            XivaSerializeUtil.writeMap(writer, body);
        }
    }
}
