package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.JsonAssert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPushMapBodyTest {
    public static final String PAYLOAD = "{'key1':'value1','map':{'map_key1':'map_value1','map_key2':'map_value2'}"
            + ",'key3':'value3'}";

    @Test
    public void serializeJson() {
        String expectedJson = ("{'payload':" + PAYLOAD + "}").replaceAll("'", "\"");
        XivaPushMapBody pushBody = XivaPushMapBody.consJson(Cf.map("key1","value1",
                "map", Cf.map("map_key1", "map_value1", "map_key2", "map_value2"),
                "key3", "value3"
        ));
        serializeAndAssertEquals(expectedJson, pushBody);
    }

    @Test
    public void serializeStr() {
        String expectedJson = ("{'payload':'" + PAYLOAD.replaceAll("(')", "\\\\\"") + "'}")
                .replaceAll("'", "\"");
        XivaPushMapBody pushBody = XivaPushMapBody.consStr(Cf.map("key1","value1",
                "map", Cf.map("map_key1", "map_value1", "map_key2", "map_value2"),
                "key3", "value3"
        ));
        serializeAndAssertEquals(expectedJson, pushBody);
    }

    private static void serializeAndAssertEquals(String expectedJson, XivaPushMapBody pushBody) {
        JsonAssert.equals(expectedJson, XivaPushBodyTest.serialize(XivaEventRecipient.passport(1L), pushBody));
    }
}
