package ru.yandex.chemodan.xiva;

import org.apache.http.Header;

import ru.yandex.bolts.collection.Option;

/**
 * @author buberman
 */
public class XivaResponseHeaders {
    public final Option<String> notificationId;
    public final Option<String> transitId;
    public final Option<String> yContext;

    private XivaResponseHeaders(Option<String> notificationId, Option<String> transitId, Option<String> yContext) {
        this.notificationId = notificationId;
        this.transitId = transitId;
        this.yContext = yContext;
    }

    public static XivaResponseHeaders cons(Header[] headers) {
        String notificationId = null;
        String transitId = null;
        String yContext = null;

        for (int i = 0; i < headers.length; i++) {
            switch (headers[i].getName()) {
                case "NotificationID" : notificationId = headers[i].getValue(); break;
                case "TransitID" : transitId = headers[i].getValue(); break;
                case "Y-Context" : yContext = headers[i].getValue(); break;
            }
        }

        return new XivaResponseHeaders(Option.ofNullable(notificationId), Option.ofNullable(transitId),
                Option.ofNullable(yContext));
    }
}
