package ru.yandex.chemodan.xiva;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class XivaSendResult extends DefaultObject {
    private static final BenderJsonParser<XivaSendResult> resultParser =
            BenderParser.cons(ClassX.wrap(XivaSendResult.class),
                    BenderConfiguration.cons(MembersToBind.ALL_FIELDS, false,
                            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                                    .add(String.class, (JsonFieldLevelUnmarshaller) (node, ctx) -> parseAsString(node))
                                    .build()
                    )
            );

    @BenderPart(name = "code")
    public final int status;

    public final String body;

    @BenderPart(name = "id")
    public final Option<String> subscriptionId;

    public XivaSendResult(int status, String body) {
        this(status, body, Option.empty());
    }

    public XivaSendResult(int status, String body, String subscriptionId) {
        this(status, body, Option.of(subscriptionId));
    }

    private XivaSendResult(int status, String body, Option<String> subscriptionId) {
        this.status = status;
        this.body = body;
        this.subscriptionId = subscriptionId;
    }

    public static ListF<ListF<XivaSendResult>> parseBatchResponse(InputStreamSource iss) {
        return BenderParserUtils.json(iss)
                .getField("results")
                .map(node -> node.getArrayElements()
                        .map(childNode -> childNode.isArray()
                                ? childNode.getArrayElements().map(XivaSendResult::parseBatchResult)
                                : Cf.list(parseBatchResult(childNode))
                        )
                )
                .getOrElse(Cf.list());
    }

    private static XivaSendResult parseBatchResult(BenderJsonNode node) {
        return resultParser.parseJson(node);
    }

    private static ParseResult<Object> parseAsString(BenderJsonNode node) {
        return ParseResult.result(node.isValueNode() ? node.getValueAsString() : node.toString());
    }

    public boolean isOk() {
        return HttpStatus.is2xx(status);
    }
}
