package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaSendResultTest {
    @Test
    public void testBatchResponseParsing() {
        String json = ("{'results':["
                + "{'code':200,'body':'OK'}"
                + ",{'code':500,'body':'Internal server error'}"
                + ",["
                + "{'id':'9a4f5b5810c9fc3bac078','code': 200,'body':'OK'}"
                + ",{'id':'e4b914cd7906887b40a9f',"
                + "'code':205,'body':'gone'}"
                + "]"
                + ",{'code':409,'body':{'duplicate':5}}"
                + "]}").replaceAll("'", "\"");
        Assert.equals(
                Cf.<ListF<XivaSendResult>>list()
                        .plus1(Cf.list(new XivaSendResult(200, "OK")))
                        .plus1(Cf.list(new XivaSendResult(500, "Internal server error")))
                        .plus1(Cf.list(
                                new XivaSendResult(200, "OK", "9a4f5b5810c9fc3bac078"),
                                new XivaSendResult(205, "gone", "e4b914cd7906887b40a9f")
                        ))
                        .plus1(Cf.list(new XivaSendResult(409, "{\"duplicate\":5}")))
                ,
                XivaSendResult.parseBatchResponse(new ByteArrayInputStreamSource(json.getBytes()))
        );
    }
}
