package ru.yandex.chemodan.xiva;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.Format;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyMarshallerContext;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaSerializeUtil {
    private static final BenderConfiguration benderConfiguration = new BenderConfiguration(
            new BenderSettings(MembersToBind.ALL_FIELDS),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .build());

    public static String serializeToString(Map value) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {
            BenderJsonWriter json = BenderJsonWriter.json(baos);
            writeMap(json, value);
            json.flush();
            return baos.toString();
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static void writeMap(BenderJsonWriter writer, Map value) {
        writer.writeObjectStart();
        writeMapContents(writer, value);
        writer.writeObjectEnd();
    }

    public static void writeMapContents(BenderJsonWriter writer, Map<?, ?> map) {
        map.forEach((key, value) -> {
            writer.writeFieldName(key.toString());
            writeFieldValue(writer, value);
        });
    }

    private static void writeFieldValue(BenderJsonWriter writer, Object value) {
        if (value instanceof Map) {
            writeMap(writer, (Map) value);
        } else {
            consFieldMarshaller(value)
                    .writeJsonToField(writer, value, new EmptyMarshallerContext());
        }
    }

    private static ToFieldMarshaller consFieldMarshaller(Object value) {
        return (ToFieldMarshaller) new MainMarshallerFactory(Format.JSON, benderConfiguration)
                .createMarshaller(
                        ClassX.wrap(value.getClass())
                                .asType()
                );
    }
}
