package ru.yandex.chemodan.xiva;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author yashunsky
 */
public class XivaSingleTokenClient {
    private final BasicXivaClient basicClient;

    private final String token;

    private final Option<String> broadcastTokenO;

    public XivaSingleTokenClient(BasicXivaClient basicClient, String token, Option<String> broadcastTokenO) {
        this.basicClient = basicClient;
        this.token = token;
        this.broadcastTokenO = broadcastTokenO;
    }

    /**
     * Returns Xiva Transit ID for logging
     */
    public XivaSendResponse send(XivaEvent event) {
        return basicClient.send(event, event.isBroadcast() ? getBroadcastToken() : token);
    }

    public ListF<XivaSubscription> list(PassportUid uid, String service) {
        return basicClient.list(uid, token, service);
    }

    private String getBroadcastToken() {
        return broadcastTokenO.getOrThrow("Broadcast token was not specified");
    }
}
