package ru.yandex.chemodan.xiva;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
@Value
@AllArgsConstructor
@Builder(builderClassName = "Builder")
public class XivaSubscription {
    private static final BenderJsonParser<XivaSubscription> parser =
            BenderParser.cons(ClassX.wrap(XivaSubscription.class), BenderConfiguration.defaultConfiguration());

    String id;

    Option<String> uuid;

    Option<String> platform;

    Option<String> filter;

    public static ListF<XivaSubscription> parseList(InputStreamSource input) {
        return parser.parseListJson(input);
    }

    public static class Builder {
        Option<String> uuid = Option.empty();

        Option<String> platform = Option.empty();

        Option<String> filter = Option.empty();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            return uuid(Option.of(uuid));
        }

        public Builder uuid(Option<String> uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder platform(String platform) {
            return platform(Option.of(platform));
        }

        public Builder platform(Option<String> platform) {
            this.platform = platform;
            return this;
        }

        public Builder filter(String filter) {
            return filter(Option.of(filter));
        }

        public Builder filter(Option<String> filter) {
            this.filter = filter;
            return this;
        }
    }
}
