package ru.yandex.chemodan.xiva;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.BenderXmlOrJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
@Value
@Builder(builderClassName = "Builder")
public class XivaSubscriptionFilter {
    Option<ListF<String>> subscriptionIds;
    Option<ListF<String>> sessions;
    Option<ListF<String>> uuids;
    Option<ListF<String>> devices;
    Option<ListF<String>> platforms;
    Option<ListF<String>> transports;

    public static Builder builder() {
        return new Builder();
    }

    @BendingMethod
    public void serialize(BenderXmlOrJsonWriter writer, PartPosition pp, MarshallerContext context) {
        serialize(writer.getJson());
    }

    public void serialize(BenderJsonWriter json) {
        json.writeArrayStart();
        writeIfPresent("subscription_id", subscriptionIds, json);
        writeIfPresent("session", sessions, json);
        writeIfPresent("uuid", uuids, json);
        writeIfPresent("device", devices, json);
        writeIfPresent("platform", platforms, json);
        writeIfPresent("transport", transports, json);
        json.writeArrayEnd();
    }

    private static void writeIfPresent(String fieldName, Option<ListF<String>> fieldValue, BenderJsonWriter json) {
        fieldValue.ifPresent(
                strings -> {
                    json.writeObjectStart();
                    json.writeFieldName(fieldName);
                    json.writeArrayStart();
                    strings.forEach(json::writeString);
                    json.writeArrayEnd();
                    json.writeObjectEnd();
                }
        );
    }

    public static class Builder {
        Option<ListF<String>> subscriptionIds = Option.empty();
        Option<ListF<String>> sessions = Option.empty();
        Option<ListF<String>> uuids = Option.empty();
        Option<ListF<String>> devices = Option.empty();
        Option<ListF<String>> platforms = Option.empty();
        Option<ListF<String>> transports = Option.empty();

        public Builder subscriptionIds(ListF<String> subscriptionIds) {
            return subscriptionIds(Option.of(subscriptionIds));
        }

        public Builder subscriptionIds(Option<ListF<String>> subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            return this;
        }

        public Builder sessions(ListF<String> sessions) {
            return sessions(Option.of(sessions));
        }

        public Builder sessions(Option<ListF<String>> sessions) {
            this.sessions = sessions;
            return this;
        }

        public Builder uuids(ListF<String> uuids) {
            return uuids(Option.of(uuids));
        }

        public Builder uuids(Option<ListF<String>> uuids) {
            this.uuids = uuids;
            return this;
        }

        public Builder devices(ListF<String> devices) {
            return devices(Option.of(devices));
        }

        public Builder devices(Option<ListF<String>> devices) {
            this.devices = devices;
            return this;
        }

        public Builder platforms(ListF<String> platforms) {
            return platforms(Option.of(platforms));
        }

        public Builder platforms(Option<ListF<String>> platforms) {
            this.platforms = platforms;
            return this;
        }

        public Builder transports(ListF<String> transports) {
            return transports(Option.of(transports));
        }

        public Builder transports(Option<ListF<String>> transports) {
            this.transports = transports;
            return this;
        }
    }
}
