package ru.yandex.chemodan.xiva;

import java.io.ByteArrayOutputStream;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaSubscriptionFilterTest {
    @Test
    public void serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BenderJsonWriter json = BenderJsonWriter.json(baos);
        new XivaSubscriptionFilter.Builder()
                .subscriptionIds(Cf.list("1", "2", "3"))
                .sessions(Cf.list("session#1", "session#2"))
                .uuids(Cf.list("1234-5678"))
                .devices(Cf.list("1-2-3-4", "12-34-56-78", "123-456-789"))
                .platforms(Cf.list("apns", "gcm"))
                .transports(Cf.list("mobile", "webpush"))
                .build()
                .serialize(json);
        json.flush();
        JsonAssert.equals(XivaSubscriptionFilterTest.class, "xiva-subscriptions.json",
                baos.toByteArray()
        );
    }
}
