package ru.yandex.chemodan.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaSubscriptionTest {
    @Test
    public void test() {
        String json = ("[{\n" +
                "\t'client' : 'disk_desktop_win',\n" +
                "\t'filter' : '',\n" +
                "\t'id' : '230f6c40c04a23ebb628ecbf7d4059e5f5bbf5be',\n" +
                "\t'session' : '6d716864c7fc468ebf3adff2ef474598',\n" +
                "\t'ttl' : 8,\n" +
                "\t'url' : 'http://myt5-b07e4b7f18f7.qloud-c.yandex.net:1080/notify/disk-json?subscription_id=${subscription-id}'\n" +
                "}," +
                "{\n" +
                "\t'client' : 'mobile',\n" +
                "\t'extra' : '',\n" +
                "\t'filter' : '',\n" +
                "\t'id' : 'mob:7a5159e99cc542b9af1630650f532f26',\n" +
                "\t'platform' : 'apns',\n" +
                "\t'session' : '7a5159e99cc542b9af1630650f532f26',\n" +
                "\t'ttl' : 8760,\n" +
                "\t'uuid' : '7a5159e99cc542b9af1630650f532f26'\n" +
                "}]"
        ).replaceAll("'", "\"");
        Assert.equals(
                Cf.list(
                        new XivaSubscription("230f6c40c04a23ebb628ecbf7d4059e5f5bbf5be", Option.empty(),
                                Option.empty(), Option.of("")),
                        new XivaSubscription("mob:7a5159e99cc542b9af1630650f532f26",
                                Option.of("7a5159e99cc542b9af1630650f532f26"),
                                Option.of("apns"), Option.of(""))
                ),
                XivaSubscription.parseList(new ByteArrayInputStreamSource(json.getBytes()))
        );
    }
}
