package ru.yandex.chemodan.xiva;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.spring.MapProperties;
import ru.yandex.chemodan.util.spring.YaTeamQualifier;

/**
 * @author akirakozov
 */
@Configuration
public class XivaYaTeamClientContextConfiguration {
    @Value("${xiva.ya-team.host}")
    private String xivaHost;

    @Bean
    @YaTeamQualifier
    protected BasicXivaClient yaTeamBasicXivaClient() {
        return new BasicXivaClient(xivaHost, xivaYaTeamHttpClientConfigurator().configure());
    }

    @Bean
    protected MapProperties yateamXivaTokensMapProperties() {
        return new MapProperties("xiva.yateam.service_tokens");
    }

    @Bean
    @OverridableValuePrefix("xiva_ya_team")
    public HttpClientConfigurator xivaYaTeamHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @YaTeamQualifier
    public XivaClient yaTeamXivaClient() {
        return new XivaClient(yaTeamBasicXivaClient(), yateamXivaTokensMapProperties().get());
    }
}
