package ru.yandex.chemodan.zk;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.ZkUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.version.AppName;

@Configuration
public class ChemodanZkPathsContextConfiguration {

    @Qualifier("zkAllRoot")
    @Bean
    public ZkPath zkAllRoot(EnvironmentType environmentType) {
        return ZkUtils.rootPath("all_chemodan", environmentType);
    }

    @Qualifier("zkRoot")
    @Bean
    public ZkPath zkRoot(EnvironmentType environmentType, AppName appName) {
        if (Cf.list("dataapi", "telemost").containsTs(appName.serviceName())) {
            return ZkUtils.rootPath(appName.serviceName(), environmentType);
        } else {
            return ZkUtils.rootPath("chemodan", environmentType);
        }
    }

    @Qualifier("zkBazingaRoot")
    @Bean
    public ZkPath zkBazingaRoot(
            EnvironmentType environmentType,
            @Value("${bazinga.zk.suffix:-}") String zkSuffix)
    {
        return ZkUtils.defaultRootPath("chemodan", environmentType).child("bazinga" + zkSuffix);
    }
}
