package ru.yandex.chemodan.zk.configuration;

import javax.annotation.PreDestroy;

import junit.framework.AssertionFailedError;

import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.testing.ZkTestBase;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * Spring bean wrapper for convenient using at spring tests
 * @author vpronto
 */
public class ZkEmbedded extends ZkTestBase implements AutoCloseable {

    private static final Logger logger = LoggerFactory.getLogger(ZkEmbedded.class);

    public ZkEmbedded() throws Exception {
        setUp();
    }

    @Override
    protected void startServer() throws Exception {
        try {
            super.startServer();
        } catch (AssertionFailedError error) {
            // dirty hack for ya.make real jmx beans are:
            //org.apache.ZooKeeperService:name0=StandaloneServer_port-1,name1=127.0.0.1,
            //org.apache.ZooKeeperService:name0=StandaloneServer_port-1,name1=InMemoryDataTree
            //org.apache.ZooKeeperService:name0=StandaloneServer_port-1
            // it cause to random result: can be matched one or two beans regarding to order
            logger.info("skipping jmx assert", error.getMessage());
        }
        logger.debug("ZkEmbedded started {}", getConfiguration());
    }

    /**
     * spring invokes close by default due closing context (@PreDestroy is used for legacy version)
     * @throws Exception
     */
    @PreDestroy
    @Override
    public void close() throws Exception {
        tearDown();
    }

    public ZkConfiguration getConfiguration() {
        return createConfiguration();
    }
}
