package ru.yandex.chemodan.zk.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;

/**
 * @author vpronto
 */
@Configuration
@Import(ZkManagerContextConfiguration.class)
public class ZkEmbeddedConfiguration {

    @Bean
    public ZkEmbedded zkEmbedded() throws Exception {
        return new ZkEmbedded();
    }

    @Bean
    public ZkConfiguration zkConfiguration(ZkEmbedded zkEmbedded) {
        return zkEmbedded.getConfiguration();
    }
}
