package ru.yandex.chemodan.zk.registries.staff;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author bursy
 */
public class YandexStaffUserRegistry extends ZkRegistry<PassportUid, YandexStaffUser> {

    private MapF<String, YandexStaffUser> byExternalLogin;
    private MapF<PassportUid, YandexStaffUser> byExternalUid;

    private MapF<String, YandexStaffUser> byInternalLogin;
    private MapF<PassportUid, YandexStaffUser> byInternalUid;

    public YandexStaffUserRegistry(ZkPath zkPath) {
        super(zkPath, new BenderMapper().createParserSerializer(YandexStaffUser.class),
                r -> r.getInternalUid(),
                s -> s.toString()
        );
        addListener(users -> {
            synchronized (this) {
                byExternalLogin = users.toMapMappingToKey(YandexStaffUser::getExternalLogin);
                byInternalLogin = users.toMapMappingToKey(YandexStaffUser::getInternalLogin);
                byExternalUid = users.toMapMappingToKey(YandexStaffUser::getExternalUid);
                byInternalUid = users.toMapMappingToKey(YandexStaffUser::getInternalUid);
            }
        });
    }

    public Option<YandexStaffUser> findByExtLogin(String login) {
        awaitInitialization();
        return byExternalLogin.getO(login);
    }

    public Option<YandexStaffUser> findByExtUid(PassportUid uid) {
        awaitInitialization();
        return byExternalUid.getO(uid);
    }

    public Option<YandexStaffUser> findByInternalLogin(String login) {
        awaitInitialization();
        return byInternalLogin.getO(login);
    }

    public Option<YandexStaffUser> findByInternalUid(PassportUid uid) {
        awaitInitialization();
        return byInternalUid.getO(uid);
    }

    public ListF<PassportUid> getAllExternalUids() {
        awaitInitialization();
        return byExternalUid.keys().toList();
    }

    public boolean isStaffUser(PassportUid externalUid) {
        awaitInitialization();
        return byExternalUid.containsKeyTs(externalUid);
    }

    public boolean isStaffUser(PassportUidOrZero externalUid) {
        awaitInitialization();
        return externalUid.isAuthenticated() &&
                (externalUid.isYandexTeamRu() || byExternalUid.containsKeyTs(externalUid.toUid()));
    }

    public boolean isStaffUser(long externalUid) {
        awaitInitialization();
        return byExternalUid.containsKeyTs(PassportUid.cons(externalUid));
    }

    public boolean isStaffUser(String externalLogin) {
        awaitInitialization();
        return byExternalLogin.containsKeyTs(externalLogin);
    }
}
