package ru.yandex.chemodan.zk.registries.staff;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author bursy
 */
@Configuration
public class YandexStaffUserRegistryContextConfiguration {

    @Bean
    public YandexStaffUserRegistry yandexStaffUserRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager)
    {
        YandexStaffUserRegistry registry = new YandexStaffUserRegistry(zkRoot.child("yandexoids"));
        zkManager.addClient(registry);
        return registry;
    }
}
