package ru.yandex.chemodan.zk.registries.tvm;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author tolmalev
 */
public class TvmDstClientsZkRegistry extends ZkRegistry<String, TvmDstClientsZkRegistry.TvmDstClientInfo> {
    public TvmDstClientsZkRegistry(ZkPath zkRoot) {
        super(zkRoot.child("tvm2-dst-clients"),
                BenderParserSerializer.cons(ClassX.wrap(TvmDstClientInfo.class), BenderConfiguration.defaultConfiguration()),
                info -> info.host,
                s -> s);
    }

    @BenderBindAllFields
    public static class TvmDstClientInfo extends DefaultObject {
        public final String host;
        public final Option<Integer> clientId;
        public final boolean sendUserTicket;

        public TvmDstClientInfo(String host, Option<Integer> clientId, boolean sendUserTicket) {
            this.host = host;
            this.clientId = clientId;
            this.sendUserTicket = sendUserTicket;
        }
    }
}
