package ru.yandex.chemodan.zk.registries.tvm;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.primitives.registry.RegistryDiffListener;
import ru.yandex.inside.passport.blackbox2.BlackboxType;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.AddUserTicketInterceptor;
import ru.yandex.inside.passport.tvm2.ByHostClientResolver;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.net.uri.Uri2;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        Tvm2BaseContextConfiguration.class
})
public class ZkTvm2ContextConfiguration {
    @Bean
    public TvmDstClientsZkRegistry tvmDstClientsZkRegistry(
            @Nullable Tvm2 tvm2,
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager)
    {
        if (tvm2 == null) {
            return null;
        }

        TvmDstClientsZkRegistry registry = new TvmDstClientsZkRegistry(zkRoot);

        //TODO: think about removing
        registry.addListener(new RegistryDiffListener<TvmDstClientsZkRegistry.TvmDstClientInfo>() {
            @Override
            public void changedWith(CollectionF<TvmDstClientsZkRegistry.TvmDstClientInfo> added,
                    CollectionF<TvmDstClientsZkRegistry.TvmDstClientInfo> updated,
                    CollectionF<TvmDstClientsZkRegistry.TvmDstClientInfo> removed)
            {
                tvm2.addDstClientIds(added.flatMap(info -> info.clientId).plus(updated.flatMap(info -> info.clientId)));
            }
        });

        zkManager.addClient(registry);

        return registry;
    }

    @Bean
    public AddServiceTicketInterceptor addServiceTicketInterceptor(
            @Nullable Tvm2 tvm2,
            @Nullable TvmDstClientsZkRegistry registry
    ) {
        if (tvm2 == null) {
            return null;
        }

        MapF<String, Integer> blackboxClientIds = Cf.list(BlackboxType.values())
                .toMap(type -> Tuple2.tuple(Uri2.parse(type.url()).getHost().get(), type.getTvmDstClientId()));

        return tvm2.serviceTicketInterceptor(request -> ByHostClientResolver
                    .getHost(request)
                    .flatMapO(host -> blackboxClientIds
                            .getO(host)
                            .orElse(registry.getO(host).flatMapO(i -> i.clientId))
                    )
        );
    }

    @Bean
    public AddUserTicketInterceptor addUserTicketInterceptor(@Nullable TvmDstClientsZkRegistry registry) {
        if (registry == null) {
            return null;
        }

        return new AddUserTicketInterceptor(request -> ByHostClientResolver
                .getHost(request)
                .flatMapO(registry::getO)
                .map(info -> info.sendUserTicket)
                .getOrElse(false)
        );
    }
}
