package ru.yandex.chemodan.zk.registries.tvm;

import ru.yandex.chemodan.util.tvm.TvmClientInfo;
import ru.yandex.chemodan.util.tvm.TvmClientInfoRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author tolmalev
 */
public class ZkTvmClientInfoRegistry extends ZkRegistry<Integer, TvmClientInfo> implements TvmClientInfoRegistry {
    public ZkTvmClientInfoRegistry(ZkPath zkRoot) {
        super(zkRoot.child("api-client-info"),
                BenderParserSerializer.cons(ClassX.wrap(TvmClientInfo.class), BenderConfiguration.defaultConfiguration()),
                (ci) -> ci.tvmClientId,
                (tvmId) -> (Integer.toString(tvmId)));
    }
}
