package ru.yandex.chemodan.zk.registries.tvm;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.util.tvm.TvmClientInfoRegistry;
import ru.yandex.chemodan.util.tvm.TvmContextConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class ZkTvmContextConfiguration extends TvmContextConfiguration {

    @Bean
    public TvmClientInfoRegistry clientInfoRegistry(ZkManager zkManager, @Qualifier("zkRoot") ZkPath zkRoot) {
        ZkTvmClientInfoRegistry registry = new ZkTvmClientInfoRegistry(zkRoot);
        zkManager.addClient(registry);
        return registry;
    }

}
