IF(DISK_USE_JDK15)
    MESSAGE(Using JDK15)
    JDK_VERSION(15)
ENDIF()

IF(DISK_USE_JDK17)
    MESSAGE(Using JDK17)
    JDK_VERSION(17)
    INCLUDE(${ARCADIA_ROOT}/disk/support/jdk17.inc)
ENDIF()

IF(JDK_VERSION == "")
    JDK_VERSION(11)
ENDIF()

IF(DISK_USE_JDK15 OR DISK_USE_JDK17)
    SET(log4j-version 2.17.2)
ELSE()
    SET(log4j-version 2.11.0)
ENDIF()

SET(slf4j-version 1.7.36)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/apache/logging/log4j/log4j-api/${log4j-version}
    contrib/java/org/apache/logging/log4j/log4j-core/${log4j-version}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${log4j-version}
    contrib/java/org/slf4j/slf4j-api/${slf4j-version}
    contrib/java/org/slf4j/jcl-over-slf4j/${slf4j-version}
    contrib/java/org/slf4j/jul-to-slf4j/${slf4j-version}
)

EXCLUDE(
    contrib/java/org/slf4j/slf4j-log4j12
)
