package ru.yandex.chemodan.app.dataapi.api.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.oauth.OauthAccessToken;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author tolmalev
 */
public class DataApiPassportUserId extends DataApiUserId {
    public final PassportUid uid;

    public final transient Option<String> oAuthToken;

    public DataApiPassportUserId(long uid) {
        this(new PassportUid(uid));
    }

    public DataApiPassportUserId(PassportUid uid) {
        this(uid, Option.empty());
    }

    public DataApiPassportUserId(PassportUid uid, Option<String> oAuthToken) {
        super(DataApiUserType.PASSPORT);
        this.uid = uid;
        this.oAuthToken = oAuthToken;
    }

    public static DataApiPassportUserId fromToken(OauthAccessToken token) {
        return new DataApiPassportUserId(token.uid)
                .withOAuthToken(token.token);
    }

    public DataApiPassportUserId withOAuthToken(String token) {
        return new DataApiPassportUserId(uid, Option.of(token));
    }

    @Override
    public String stringValue() {
        return Long.toString(uid.getUid());
    }

    @Override
    public long discriminant() {
        return uid.getUid();
    }

    @Override
    public PassportUidOrZero toPassportUidOrZero() {
        return uid.toUidOrZero();
    }
}
