package ru.yandex.chemodan.app.dataapi.api.user;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.chemodan.util.sharpei.UserId;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.db.shard.proxy.Discriminant;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.ToStringSerializable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author tolmalev
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class DataApiUserId extends DefaultObject implements Discriminant, UserId, ToStringSerializable {
    private static final Pattern2 typeValueDelimiter = Pattern2.compile(":");

    public final DataApiUserType type;

    public DataApiUserId(DataApiUserType type) {
        this.type = type;
    }

    public abstract String stringValue();

    @Override
    public String toString() {
        return isPassportUid()
                ? stringValue()
                : type.lowerCaseName() + ":" + stringValue();
    }

    @Override
    public long discriminant() {
        return Math.abs(toString().hashCode()) + 1;
    }

    @BenderTextValue
    public static DataApiUserId parse(String str) {
        return parse(str, Option.empty());
    }

    public static DataApiUserId parse(String str, WebRequest webRequest) {
        return parse(str, Option.of(webRequest));
    }

    private static DataApiUserId parse(String str, Option<WebRequest> webRequestO) {
        Tuple2<Option<String>, String> typeOValue = typeValueDelimiter.split2O(str)
                .map(typeValue -> typeValue.map1(Option::of))
                .getOrElse(Tuple2.tuple(Option.empty(), str));
        DataApiUserType type = typeOValue.get1()
                .map(DataApiUserType.R::valueOf)
                .getOrElse(() ->
                        StringUtils.equals("public", str)
                                ? DataApiUserType.PUBLIC
                                : DataApiUserType.PASSPORT
                );
        return type.parse(typeOValue.get2(), webRequestO);
    }

    @BenderTextValue
    public String serialize() {
        return toString();
    }

    public MpfsUser forMpfs() {
        return MpfsUser.of(serialize());
    }

    public boolean isPassportUid() {
        return type == DataApiUserType.PASSPORT;
    }

    public boolean isPublic() {
        return type == DataApiUserType.PUBLIC;
    }

    public PassportUidOrZero toPassportUidOrZero() {
        return PassportUidOrZero.zero();
    }

    public PassportUid toPassportUid() {
        return toPassportUidOrZero().toUid();
    }

    @Override
    public String asString() {
        return serialize();
    }
}
