package ru.yandex.chemodan.app.dataapi.api.user;

import org.junit.Test;

import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DataApiUserIdTest {
    @Test
    public void parse() {
        Assert.equals(new DataApiPassportUserId(10), DataApiUserId.parse("10"));
        Assert.equals(new DataApiPassportUserId(10), DataApiUserId.parse("passport:10"));

        Assert.equals(new DataApiYandexUidUserId("test1"), DataApiUserId.parse("yandex_uid:test1"));

        Assert.equals(new DataApiDeviceIdUserId("test2"), DataApiUserId.parse("device_id:test2"));

        Assert.equals(new UuidDataApiUserId("test3"), DataApiUserId.parse("uuid:test3"));

        Assert.equals(new DataApiPublicUserId(), DataApiUserId.parse("public"));
        Assert.equals(new DataApiYaTeamUserId(1120000000000001L), DataApiUserId.parse("yt:1120000000000001"));

        Assert.equals(new DataApiCustomUserId("test3"), DataApiUserId.parse("custom:test3"));
    }

    @Test
    public void string() {
        Assert.equals("100", new DataApiPassportUserId(100).toString());
        Assert.equals("yandex_uid:test1", new DataApiYandexUidUserId("test1").toString());
        Assert.equals("device_id:test2", new DataApiDeviceIdUserId("test2").toString());
        Assert.equals("uuid:test3", new UuidDataApiUserId("test3").toString());
        Assert.equals("public", new DataApiPublicUserId().toString());
        Assert.equals("yt:1120000000000001", new DataApiYaTeamUserId(1120000000000001L).toString());
        Assert.equals("custom:test3", new DataApiCustomUserId("test3").toString());
    }

    @Test
    public void bending() {
        BenderParserSerializer<WithUserId> PS = Bender.cons(WithUserId.class);

        DataApiUserId uid = new DataApiPassportUserId(1231L);
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new DataApiYandexUidUserId("test1");
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new DataApiDeviceIdUserId("test2");
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new DataApiPublicUserId();
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new UuidDataApiUserId("afsfasdfgasgd");
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new DataApiYaTeamUserId(1120000000000001L);
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);

        uid = new DataApiCustomUserId("test3");
        Assert.equals(uid, PS.getParser().parseJson(PS.getSerializer().serializeJson(new WithUserId(uid))).uid);
    }

    @BenderBindAllFields
    private static final class WithUserId extends DefaultObject {
        public final DataApiUserId uid;

        private WithUserId(DataApiUserId uid) {
            this.uid = uid;
        }
    }
}
