package ru.yandex.chemodan.app.dataapi.api.user;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.oauth.OAuthUtils;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author tolmalev
 */
public enum DataApiUserType {
    PASSPORT((s, webRequestO) -> new DataApiPassportUserId(
            new PassportUid(Long.parseLong(s)),
            extractOAuthToken(webRequestO)
    )),
    YT(DataApiYaTeamUserId::new),
    YANDEX_UID(DataApiYandexUidUserId::new),
    DEVICE_ID(DataApiDeviceIdUserId::new),
    PUBLIC(s -> new DataApiPublicUserId()),
    UUID(UuidDataApiUserId::new),
    CUSTOM(DataApiCustomUserId::new)
    ;

    private final Function2<String, Option<WebRequest>, DataApiUserId> parseF;

    DataApiUserType(Function<String, DataApiUserId> parseF) {
        this((s, webRequest) -> parseF.apply(s));
    }

    DataApiUserType(Function2<String, Option<WebRequest>, DataApiUserId> parseF) {
        this.parseF = parseF;
    }

    public DataApiUserId parse(String str) {
        return parse(str, Option.empty());
    }

    public DataApiUserId parse(String str, Option<WebRequest> webRequestO) {
        return parseF.apply(str, webRequestO);
    }

    public static final EnumResolver<DataApiUserType> R = EnumResolver.er(DataApiUserType.class);

    public String lowerCaseName() {
        return name().toLowerCase();
    }

    static Option<String> extractOAuthToken(Option<WebRequest> requestO) {
        return requestO.filterMap(
                request -> OAuthUtils.getOAuthToken(request.getHeader("Authorization"))
        );
    }
}
