package ru.yandex.chemodan.app.dataapi.api.user;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataApiUserTypeTest {
    @Test
    public void extractOAuthToken() {
        String token = "AQAAAAABbcCCAANnTfXMwqTzxER-aB7cDEfGhik";

        WebRequest requestMock = Mockito.mock(WebRequest.class);
        Mockito.when(requestMock.getHeader("Authorization"))
                .thenReturn(Option.of("OAuth " + token));

        Assert.equals(
                Option.of(token),
                DataApiUserType.extractOAuthToken(Option.of(requestMock))
        );
    }
}
