package ru.yandex.chemodan.app.dataapi.api.user;

import ru.yandex.bolts.internal.Validate;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public class DataApiYaTeamUserId extends DataApiUserId {
    public final PassportUid uid;

    public DataApiYaTeamUserId(long uid) {
        super(DataApiUserType.YT);
        this.uid = new PassportUid(uid);
        Validate.isTrue(this.uid.isYandexTeamRu(), "Should be ya-team user");
    }

    public DataApiYaTeamUserId(String uid) {
        this(Long.parseLong(uid));
    }

    @Override
    public String stringValue() {
        return Long.toString(uid.getUid());
    }

    @Override
    public long discriminant() {
        return uid.getUid();
    }

    @Override
    public PassportUidOrZero toPassportUidOrZero() {
        return uid.toUidOrZero();
    }

}
