package ru.yandex.chemodan.app.dataapi.api.user;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class UsersIterationKey {
    public final int shardId;
    public final int partitionNo;
    public final DataApiUserId prevUid;

    public UsersIterationKey(int shardId, int partitionNo, DataApiUserId prevUid) {
        this.shardId = shardId;
        this.partitionNo = partitionNo;
        this.prevUid = prevUid;
    }

    @Override
    public String toString() {
        return Cf.list(shardId, partitionNo, prevUid).mkString(":");
    }

    @BenderTextValue
    public static UsersIterationKey parse(String string) {
        String[] parts = string.split(":");
        Validate.ge(parts.length, 3);

        return new UsersIterationKey(
                Integer.parseInt(parts[0]),
                Integer.parseInt(parts[1]),
                DataApiUserId.parse(Cf.x(parts).drop(2).mkString(":")));
    }

    @BenderTextValue
    public String serialize() {
        return toString();
    }
}
