package ru.yandex.chemodan.app.dataapi.api.user;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@ActionResultPojo
@BenderBindAllFields
public class UsersPojo {
    public final int limit;
    public final ListF<User> items;
    @BenderPart(name = "iteration_key", strictName = true)
    public final Option<UsersIterationKey> iterationKey;

    public UsersPojo(int limit, CollectionF<DataApiUserId> items, Option<UsersIterationKey> iterationKey) {
        this.limit = limit;
        this.items = items.map(User::new);
        this.iterationKey = iterationKey;
    }

    @BenderBindAllFields
    public static class User {
        public final DataApiUserId uid;

        public User(DataApiUserId uid) {
            this.uid = uid;
        }
    }
}
