package ru.yandex.chemodan.eventlog;

import org.junit.Test;

import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLineTest;
import ru.yandex.misc.monica.core.blocks.AverageData;
import ru.yandex.misc.monica.core.blocks.Meter;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EventLogListenerSupportTest {

    private static final String UNKNOWN_EVENT_TYPE = "some_unknown_type";

    private final EventLogListenerSupport listener = new EventLogListenerSupport() {
        public void processEvent(AbstractEvent event) {

        }
    };

    @Test
    public void missingEventTypeMustBeRegisteredAsParseError() {
        assertMetricIsNotZero(
                TskvEventLogLineTest.MISSING_EVENT_TYPE_LOG_LINE,
                EventLogListenerSupport.UNSPECIFIED_EVENT_TYPE_VALUE,
                listener.parseErrors);
    }

    @Test
    public void unknownEventTypeMustBeRegisteredAsParseError() {
        assertMetricIsNotZero(
                "tskv\tevent_type=" + UNKNOWN_EVENT_TYPE,
                UNKNOWN_EVENT_TYPE,
                listener.unknownTypes);
    }

    private void assertMetricIsNotZero(String line, String name, MeterMap meterMap) {
        listener.processLogLine(line);

        Meter meter = meterMap.get(new MetricName(name));
        meter.tick(System.currentTimeMillis());

        Assert.notEquals(meter.meter().getValue(), AverageData.EMPTY);
    }

}
