package ru.yandex.chemodan.eventlog.celery;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.eventlog.log.TskvLogLine;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CeleryLogLineUtils {
    public static CeleryOnetimeTaskParameters toCeleryOneTimeTaskParameters(TskvLogLine tskvLogLine) {
        return new CeleryOnetimeTaskParameters(
                Cf.list(new JsonObject(tskvLogLine.toMap().mapValues(JsonString::valueOf))),
                Cf.map()
        );
    }

    public static String toTskvLogLine(CeleryOnetimeTaskParameters parameters) {
        return TskvUtils.formatTskvLine(
                ((JsonObject) parameters.args.first())
                        .getObject()
                        .map2(v -> ((JsonString) v).getString())
                        .toMap()
        );
    }

    public static CeleryOnetimeTaskParameters toCeleryOneTimeTaskParameters(String logLine) {
        return new CeleryOnetimeTaskParameters(
                Cf.list(new JsonObject(Cf.map("line", JsonString.valueOf(logLine)))),
                Cf.map()
        );
    }

    public static String toLogLine(CeleryOnetimeTaskParameters parameters) {
        return ((JsonString) ((JsonObject) parameters.args.first()).get("line")).getString();
    }
}
