package ru.yandex.chemodan.eventlog.celery;

import org.joda.time.Duration;

import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.salr.logreader.LogListener;

/**
 * @author bursy
 */
public abstract class ProcessLogLineCeleryTask<T extends LogListener> extends CeleryOnetimeTask {
    private T listener;

    public ProcessLogLineCeleryTask(T listener) {
        this.listener = listener;
    }

    public ProcessLogLineCeleryTask(CeleryOnetimeTaskParameters celeryOnetimeTaskParameters) {
        super(celeryOnetimeTaskParameters);
    }

    protected abstract String toLogLine(CeleryOnetimeTaskParameters celeryOnetimeTaskParameters);

    @Override
    protected void execute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) throws Exception {
        listener.processLogLine(toLogLine(parameters));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(2);
    }
}
