package ru.yandex.chemodan.eventlog.events;

import java.util.Objects;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.eventlog.events.album.ChangeCoverAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangeCoverOffsetAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangePublicityAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChangeTitleAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ChildAlbumItemEvent;
import ru.yandex.chemodan.eventlog.events.album.CreateAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.PostToSocialAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.RemoveAlbumEvent;
import ru.yandex.chemodan.eventlog.events.album.ResourceAlbumItemEvent;
import ru.yandex.chemodan.eventlog.events.billing.BillingEvent;
import ru.yandex.chemodan.eventlog.events.comment.CommentEvent;
import ru.yandex.chemodan.eventlog.events.comment.LikeDislikeEvent;
import ru.yandex.chemodan.eventlog.events.fs.FsEvent;
import ru.yandex.chemodan.eventlog.events.fs.MksysdirFsEvent;
import ru.yandex.chemodan.eventlog.events.fs.TrashDropAllFsEvent;
import ru.yandex.chemodan.eventlog.events.invite.ActivationInviteEvent;
import ru.yandex.chemodan.eventlog.events.invite.SentInviteEvent;
import ru.yandex.chemodan.eventlog.events.lenta.LentaLogDummyEvent;
import ru.yandex.chemodan.eventlog.events.lenta.share.SharedFolderInviteEvent;
import ru.yandex.chemodan.eventlog.events.sharing.ShareEvent;
import ru.yandex.chemodan.eventlog.events.space.BasicSpaceEvent;
import ru.yandex.chemodan.eventlog.events.space.ProductSpaceEvent;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
@BenderParseSubclasses(
       value = {
               MksysdirFsEvent.class, TrashDropAllFsEvent.class,
               CreateAlbumEvent.class, RemoveAlbumEvent.class,
               ChangePublicityAlbumEvent.class, ChangeTitleAlbumEvent.class,
               ChangeCoverAlbumEvent.class, ChangeCoverOffsetAlbumEvent.class,
               ChildAlbumItemEvent.class, ResourceAlbumItemEvent.class,
               PostToSocialAlbumEvent.class,
               FsEvent.class, BillingEvent.class, ShareEvent.class,
               SentInviteEvent.class, ActivationInviteEvent.class,
               BasicSpaceEvent.class, ProductSpaceEvent.class,
               CommentEvent.class, LikeDislikeEvent.class,
               SharedFolderInviteEvent.class, LentaLogDummyEvent.class
       }
)
public abstract class AbstractEvent extends DefaultObject {
    private static final char ID_CHUNKS_SEPARATOR = '|';

    @BenderFlatten
    public final EventMetadata metadata;

    // Bender serialization workaround - superclass annotated methods not serialized
    @BenderFlatten
    public final Keys keys = new Keys();

    protected AbstractEvent(EventMetadata metadata) {
        this.metadata = metadata;
    }

    public final MpfsUid getUid() {
        return metadata.uid;
    }

    public abstract EventType getEventType();

    public abstract ListF<Object> getGroupChunks();

    public abstract ListF<Object> getNameChunks();

    protected ListF<AbstractEvent> createExtraEvents() {
        return Cf.list();
    }

    public ListF<AbstractEvent> getEvents() {
        return Cf.list(this)
                .plus(createExtraEvents());
    }

    public ListF<AbstractEvent> getAcceptedEvents() {
        return getEvents().filterNot(AbstractEvent::reject);
    }

    public ListF<AbstractEvent> getRejectedEvents() {
        return getEvents().filter(AbstractEvent::reject);
    }

    public PassportUid getPassportUid() {
        return getUid().getUid();
    }

    @Bendable
    public class Keys {
        @SuppressWarnings("unused")
        @BenderPart(name = "event_class", strictName = true)
        public EventCategory getKeyEventCategory() {
            return getEventType().category;
        }

        @SuppressWarnings("unused")
        @BenderPart(name = "event_type", strictName = true)
        public EventType getKeyEventType() {
            return getEventType();
        }

        @BenderPart(name = "id", strictName = true)
        public String getId() {
            ListF<Object> chunks = Cf.list()
                    .plus(getEventType())
                    .plus(getGroupChunks())
                    .plus(getNameChunks())
                    .plus1(metadata.getTimestampInSeconds());
            return StringUtils.join(chunks, ID_CHUNKS_SEPARATOR);
        }

        @SuppressWarnings("unused")
        @BenderPart(name = "group_key", strictName = true)
        public String getGroupKey() {
            if (getEventType().isGroup()) {
                return StringUtils.join(Cf.list().plus(getEventType()).plus(getGroupChunks()), ID_CHUNKS_SEPARATOR);
            } else {
                return getId();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }

            if (!(o instanceof Keys)) {
                return false;
            }

            Keys keys = (Keys) o;
            return Objects.equals(getId(), keys.getId()) && Objects.equals(getGroupKey(), keys.getGroupKey());
        }

        @Override
        public int hashCode() {
            return Objects.hash(getId(), getGroupKey());
        }

        @Override
        public String toString() {
            MapF<String, Object> fieldValues = Cf.<String, Object>map()
                    .plus1("eventType", getKeyEventType())
                    .plus1("id", getId())
                    .plus1("groupKey", getGroupKey());
            return StringUtils.join(fieldValues.mapEntries((field, value) -> field + "=" + value), ", ");
        }
    }

    public final boolean reject() {
        return getUid().isSpecial()
                || getEventType().reject()
                || rejectInternal()
                || !acceptInternal();
    }

    // override in subclasses
    protected boolean rejectInternal() {
        return false;
    }

    // override in subclasses
    protected boolean acceptInternal() {
        return true;
    }
}
