package ru.yandex.chemodan.eventlog.events;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.events.fs.TemporaryFsEventGroup;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class CompoundResourceType extends DefaultObject {
    @BenderPart(name = "resource_type", strictName = true)
    public final ResourceType type;

    @BenderPart(name = "resource_media_type", strictName = true)
    public final Option<MediaType> mediaType;

    private CompoundResourceType(ResourceType type) {
        this(type, Option.empty());
    }

    private CompoundResourceType(ResourceType type, MediaType mediaType) {
        this(type, Option.of(mediaType));
    }

    public CompoundResourceType(ResourceType type, Option<MediaType> mediaType) {
        this.type = type;
        this.mediaType = mediaType;
    }

    public TemporaryFsEventGroup getTemporaryGroup() {
        return TemporaryFsEventGroup.byCompoundType(this);
    }

    public static CompoundResourceType file(String mediaType) {
        return new CompoundResourceType(ResourceType.FILE, new MediaType(mediaType));
    }

    public static CompoundResourceType directory() {
        return new CompoundResourceType(ResourceType.DIRECTORY);
    }

    public static CompoundResourceType album() {
        return new CompoundResourceType(ResourceType.ALBUM);
    }

    public String mediaTypeValueOrUnknown() {
        return mediaType.map(t -> t.value).getOrElse("unknown");
    }
}
