package ru.yandex.chemodan.eventlog.events;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.eventlog.log.TskvEventType;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EventMetadataTest {
    @Test
    public void testReceiveDelay() {
        Instant eventTime = Instant.parse("2015-12-17T20:38:11");
        Instant receiveTime = Instant.parse("2015-12-17T20:38:23");
        EventMetadata eventMetadata = new EventMetadata(
                TskvEventType.STUB, new MpfsUid(1L), eventTime,
                Option.of(receiveTime), Option.empty(), Option.empty(), Option.empty());

        Assert.equals(Duration.standardSeconds(12), eventMetadata.getReceiveDelay());
    }

    @Test
    public void testVersionAdvance() {
        Instant receiveTime = Instant.parse("2015-12-17T20:38:25");
        EventMetadata eventMetadata = new EventMetadata(
                TskvEventType.STUB, new MpfsUid(1L), receiveTime,
                Option.of(receiveTime), Option.empty(), Option.empty(), Option.empty());

        Assert.equals(Instant.parse("2015-12-17T20:38:35"), eventMetadata.version);
    }
}
